#import <UIKit/UIKit.h>

@protocol AccelerometerHelperDelegate <NSObject>
@optional
- (void) shake; // Zdarzenie wstrząśnięcia.
- (void) ping; // Zdarzenie przyśpieszeniomierza.
@end

@interface AccelerometerHelper : NSObject <UIAccelerometerDelegate>
{
	float	cx, cy, cz; // Bieżący wektor siły.
	float	lx, ly, lz; // Ostatni wektor siły.
	float	px, py, pz; // Poprzedni wektor siły.
	
	float	sensitivity;
	
	NSDate	*triggerTime;
	NSTimeInterval lockout;
	
	id <AccelerometerHelperDelegate> delegate;	
}

+ (AccelerometerHelper *) sharedInstance;

- (BOOL) checkTrigger;
- (float) dAngle;

@property (retain)	NSDate *triggerTime;
@property (assign)	float sensitivity;
@property (assign)	NSTimeInterval lockout;
@property (retain)	id delegate;
@end
